<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


// Route::get('/', function () {
    // return view('welcome');
// });








Route::group(['middleware' => 'auth'], function () {
	
	
	Route::group(['middleware' => ['employee','e_store','admin','purchasing'] ], function () {
		
		Route::get('/', 'HomeController@index')->name('home');
		Route::get('/home', 'HomeController@index')->name('home');
		
		
		Route::get('/sku', 'SkusController@getIndex');
		Route::get('/sku_add', 'SkusController@getSku_add');
		Route::post('/sku_add', 'SkusController@postSku_add');
		Route::get('/sku/upload', 'SkusController@getSku_upload');
		Route::post('/sku_upload', 'SkusController@postSku_upload');
		Route::get('/sku/edit/{id}', 'SkusController@getSku_edit');
		Route::post('/sku/edit', 'SkusController@postSku_edit');
		
		Route::post('/sku/check', 'SkusController@postSku_check');
		
		
		Route::get('/count', 'CountsController@getIndex');
		Route::get('/count/add', 'CountsController@getCount_add');
		Route::post('/count/add', 'CountsController@postCount_add');
		Route::get('/count/download', 'CountsController@getCount_download');
		Route::post('/count/download', 'CountsController@postCount_download');
		Route::get('/count/edit/{id}', 'CountsController@getCount_edit');
		Route::post('/count/edit', 'CountsController@postCount_edit');
		
		
		Route::get('/print', 'HomeController@getPrint_home');
		Route::get('/print_so/{id}', 'Special_ordersController@getPrint_so');
		
		Route::get('/special_order/{order_status?}', 'Special_ordersController@getIndex');
		Route::get('/special_order_add', 'Special_ordersController@getSpecial_order_add');
		Route::post('/special_order_add', 'Special_ordersController@postSpecial_order_add');
		Route::get('/special_order_edit/{id}', 'Special_ordersController@getSpecial_order_edit');
		Route::post('/special_order_edit/{id}', 'Special_ordersController@postSpecial_order_edit');
		
	});
	
	
	Route::group(['middleware' => ['employee','e_store','purchasing','admin'] ], function () {
		
		Route::get('/cancel_order/{id}/{po_id?}', 'Purchase_ordersController@getCancel_order');
	   
	});
	
	
	Route::group(['middleware' => ['purchasing','admin'] ], function () {
		
		Route::get('/vendor', 'VendorsController@getIndex');
		Route::get('/vendor_add', 'VendorsController@getVendor_add');
		Route::post('/vendor_add', 'VendorsController@postVendor_add');
		
		Route::get('/vendor_edit/{id}', 'VendorsController@getVendor_edit');
		Route::post('/vendor_edit/{id}', 'VendorsController@postVendor_edit');
		
		Route::get('/vendor_disable/{id}', 'VendorsController@getVendor_disable');
		Route::get('/vendor_enable/{id}', 'VendorsController@getVendor_enable');
		
		
		Route::get('/purchase_order', 'Purchase_ordersController@getIndex');
		Route::post('/purchase_order_add', 'Purchase_ordersController@postPurchase_order_add');
		Route::get('/purchase_order_add', 'Purchase_ordersController@getPurchase_order_add');
		Route::post('/purchase_order_edit', 'Purchase_ordersController@postPurchase_order_edit');
		Route::get('/purchase_order_edit/{id}', 'Purchase_ordersController@getPurchase_order_edit');
		Route::post('/add_orders_to_purchase_order', 'Purchase_ordersController@postAdd_orders_to_purchase_order');
		Route::post('/cancel_orders', 'Purchase_ordersController@postCancel_orders');
		Route::post('/receive_orders', 'Special_ordersController@postReceive_orders');
		
		Route::get('/message', 'MessagesController@getIndex');
		Route::post('/message_add', 'MessagesController@postMessage_add');
		Route::get('/message_add', 'MessagesController@getmessage_add');
		Route::post('/message_edit', 'MessagesController@postmessage_edit');
		Route::get('/message_edit/{id}', 'MessagesController@getmessage_edit');
		Route::get('/message_disable/{id}', 'MessagesController@getMessage_disable');
		Route::get('/message_enable/{id}', 'MessagesController@getMessage_enable');
		
		// Route::get('/cancel_order/{id}/{po_id?}', 'Purchase_ordersController@getCancel_order');
		
		
	   
	});
	
	Route::group(['middleware' => ['employee','e_store','admin']], function () {
				
		
		Route::get('/user', 'UsersController@getIndex');
		Route::get('/user_add', 'UsersController@getUser_add');
		Route::post('/user_add', 'UsersController@postUser_add');
		
		Route::get('/user_edit/{id}', 'UsersController@getUser_edit');
		Route::post('/user_edit/{id}', 'UsersController@postUser_edit');
		
	   
	});
	
	Route::group(['middleware' => ['admin']], function () {
		
		Route::get('/user', 'UsersController@getIndex');
		Route::get('/user_add', 'UsersController@getUser_add');
		Route::post('/user_add', 'UsersController@postUser_add');
		
		Route::get('/user_edit/{id}', 'UsersController@getUser_edit');
		Route::post('/user_edit/{id}', 'UsersController@postUser_edit');
		
		
		Route::get('/store', 'StoresController@getIndex');
		Route::get('/store_add', 'StoresController@getStore_add');
		Route::post('/store_add', 'StoresController@postStore_add');
		
		Route::get('/store_edit/{id}', 'StoresController@getStore_edit');
		Route::post('/store_edit/{id}', 'StoresController@postStore_edit');
		
	   
	});

});


Auth::routes();


Route::post('/register', 'UsersController@postUserRegister');
Route::post('/login', '\App\Http\Controllers\Auth\LoginController@postLogin');
Route::get('/logout', '\App\Http\Controllers\Auth\LoginController@logout');