@extends($layout)

@section('content')

<!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Special_orders <small></small></h3>
              </div>

              <div class="title_right" style="visibility: hidden;">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for...">
                    <span class="input-group-btn">
                      <button class="btn btn-default" type="button">Go!</button>
                    </span>
                  </div>
                </div>
              </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Special_order's List <small></small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th style="width: 30px;" >ID</th>
                          <th>Date</th>
                          <th >Location</th>
                          <th >Quantities</th>
                          <th>SKU</th>
                          <th>Vendor</th>
                          <th style="width: 50px;" >Quoted Price</th>
                          <th style="width: 50px;" >Customer Name</th>
                          <th style="width: 50px;" >Home Phone</th>
                          @if ( Auth::user()->type == "purchasing"  ) <th style="width: 50px;" >Comments</th> @endif
                          <th>State</th>
                          <th class="action" style="width: 50px;">Action</th>
                        </tr>
                      </thead>


                      <tbody>
					  
						@foreach ($special_orders as $special_order)
							<tr id="{{ $special_order->id }}" style="" class=""  >
 								<th style="font-size: 16px;" > 
									<label for="check_{{ $special_order->id }}"> {{ $special_order->id }}  </label>
									@if ( Auth::user()->type == "purchasing"  ) <input type="checkbox" class="special_order_checkbox" id="check_{{ $special_order->id }}" status="{{ $special_order->status }}" order_id="{{ $special_order->id }}" > @endif
								</th>
								<td>{{ $special_order->date }}</td>
								<td>{{ $special_order->store_nbr }}</td>
								<td>{{ $special_order->qty }}</td>
								<td>{{ $special_order->sku }}</td>
								<td>{{ $special_order->vendor_name }}</td>
								<td>{{ $special_order->quoted_price }}</td>
								<td>{{ $special_order->customer_name }}</td>
								<td>{{ $special_order->home_phone }}</td>
								@if ( Auth::user()->type == "purchasing"  ) <td>{{ $special_order->comments }}</td> @endif
								
								<td style="color:  @if ( $special_order->status == "waiting"  ) blue @endif @if ( $special_order->status == "ordered" || $special_order->status == "received"  ) green @endif @if ( $special_order->status == "canceled"  ) red @endif ; @if ( $special_order->status == "received"  ) text-shadow: 0 0 3px #18FF00, 0 0 5px #00FF30; @endif" >
									{{ $special_order->status }}
								</td>
								<td >
									<a href="{!! url('/special_order_edit/'.$special_order->id) !!}" type="button" class="btn btn-default btn-info btn-xs ">Edit</a>
									@if ( $special_order->status  == "waiting"  )<a href="{!! url('/cancel_order/'.$special_order->id) !!}" type="button" class="btn btn-default btn-danger btn-xs ">Cancel</a> @endif 
								</td>
							</tr>
						@endforeach
                      </tbody>
						<tfoot>
							<tr>
								<th >ID</th>
								<th>Date</th>
								<th>Location</th>
								<th>Quantities</th>
								<th>SKU</th>
								<th>Vendor</th>
								<th>SKU</th>
								<th>Customer Name</th>
								<th>Home Phone</th>
								@if ( Auth::user()->type == "purchasing"  ) <th style="width: 50px;" >Comments</th> @endif
								<th>State</th>
								<th class='hidden' >Action</th>
							</tr>
						</tfoot>
                    </table>
					
					@if ( Auth::user()->type == "purchasing"  ) 
						<!-- bulk actions -->
						@include('bulk_action')
					@endif
					
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
        <!-- /page content -->

@endsection
