@extends($layout)

@section('content')
<script>
	$( document ).ready(function() {
		
		$( ".file_input" ).attr("type","");
		$( ".file_input" ).attr("type","file");
		
		
		window.articles_input_clone = $( ".article_inputs" ).first().clone() ;
		window.articles_input_clone.find ( "input").attr("value","");
		window.articles_input_clone.find ( "textarea").html("");
		window.articles_input_clone.find ( ".article_id").attr("value","add");
		
		window.file_input_clone = $( ".file_inputs" ).first().clone() ;
		window.file_input_clone.find ( "input").attr("type","");
		window.file_input_clone.find ( "input").attr("type","file");
		window.file_input_clone.find ( "input").attr("required","required");
		
		
		
		$( document ).find(".remove_article").hide();
		$( document ).find(".remove_file").hide();
		
		$( document ).on('click', '.add_article', function() {
			window.articles_input_clone.clone().insertAfter( $( ".article_inputs" ).last() );
			$('.add_article').hide();
			$('.add_article').first().show();
		});
		
		$( document ).on('click', '.add_file', function() {
			window.file_input_clone.clone().insertAfter( $( ".file_inputs" ).last() );
			$('.add_file').hide();
			$('.add_file').first().show();
		});
		
		$( document ).on('click', '.remove_article', function() {
			if ( $( ".article_inputs" ).length != 1 )
				$( this ).parent().parent().parent().remove();
		});
		
		$( document ).on('click', '.remove_file', function() {
			if ( $( ".file_inputs" ).length != 1 )
				$( this ).parent().parent().parent().remove();
		});
		
		$('form').submit(function() {
			var counter = 0;
			$( ".article_inputs" ).each(function( index1 ) {
				$( this ).find("input , textarea").each(function( index2 ) {
					curr_name = $( this ).attr("name");
					valid_name = curr_name.replace("x", counter)
					$( this ).attr("name",valid_name);
				});
				counter++;
			});
		});
		
		$('#id_societe').on('change', function() {
		   window.societe_id = this.value;
		});
		$('#id_societe').change();
	});
</script>
<!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Add new Special Order</h3>
              </div>

              <div class="title_right" style="visibility: hidden;">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for...">
                    <span class="input-group-btn">
                              <button class="btn btn-default" type="button">Go!</button>
                          </span>
                  </div>
                </div>
              </div>
            </div>
            <div class="clearfix"></div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Special Order Data<small> Please fill all required fields *</small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">

                    <form class="form-horizontal form-label-left" novalidate action="special_order_add" method="post" enctype="multipart/form-data">

					
					@if ( Auth::user()->type != "employee"  )
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Store <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
						  <select class="form-control" id="salesperson_id" name="salesperson_id" required="required" >
							@foreach ($stores as $store)
								<option value="{{ $store->id }}"> Store#: {{ $store->store_nbr }} </option>
							@endforeach
						  </select>
                        </div>
                      </div>
					@endif 
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Staff ID <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input  id="staff_id" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="staff_id" placeholder="" required="required" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Vendor <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
						  <select class="form-control" id="vendor_id" name="vendor_id" required="required" >
						    <option value="" selected="selected" >Choose Vendor</option>
							@foreach ($vendors as $vendor)
								<option value="{{ $vendor->id }}">{{ $vendor->name }}</option>
							@endforeach
						  </select>
                        </div>
                      </div>
					  
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Customer Name <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="customer_name" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="customer_name" placeholder="" required="required" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Home Phone <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="home_phone" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="home_phone" placeholder="" required="required" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Work Phone <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="work_phone" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="work_phone" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Address <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="address" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="address" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> City <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="city" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="city" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Province <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="province" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="province" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Postal Code <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="postal_code" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="postal_code" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name"> Customer PO# <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="customer_PO" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="customer_PO" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="textarea"> Comments <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <textarea id="comments" name="comments" class="form-control col-md-7 col-xs-12"></textarea>
                        </div>
                      </div>
					  
                      
                      
					  
					  <div class="ln_solid"></div>
					  <div class="x_title article_inputs">
						<h2>Articles<small> Please fill all required fields *</small></h2>
						<ul class="nav navbar-right panel_toolbox">
						  <li><a class="add_article"><i style="font-size: 30px;color: green;" class="fa fa-plus"></i></a>
						  <a class="remove_article"><i style="font-size: 30px;color: red;" class="fa fa-minus"></i></a>
						  </li>
						</ul>
						<div class="clearfix"></div>
						
						<div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">SKU <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="sku" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="articles[x][sku]" placeholder="" required="required" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">CAT <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="cat" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="articles[x][cat]" placeholder="" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Quantity<span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="qty" class="form-control col-md-7 col-xs-12" data-validate-length-range="1"  name="articles[x][qty]" placeholder="" required="required" type="number">
                        </div>
                      </div>
					  
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="textarea">Description <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <textarea required="required" id="description" name="articles[x][description]" class="form-control col-md-7 col-xs-12"></textarea>
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Net Price<span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="net_price" class="form-control col-md-7 col-xs-12" data-validate-length-range="1"  name="articles[x][net_price]" placeholder="" type="number">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">quoted Price<span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="quoted_price" class="form-control col-md-7 col-xs-12" data-validate-length-range="1"  name="articles[x][quoted_price]" placeholder="" required="required" type="number">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Pre Payment<span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="pre_payment" class="form-control col-md-7 col-xs-12" data-validate-length-range="1"  name="articles[x][pre_payment]" placeholder="" type="number">
                        </div>
                      </div>
					  
					  <hr style="height: 5px; background: black;" >
					  
					  </div>
					  
					  <div class="ln_solid"></div>
					  <div class="x_title file_inputs">
						<h2>Files<small> </small></h2>
						<ul class="nav navbar-right panel_toolbox">
						  <li><a class="add_file"><i style="font-size: 30px;color: green;" class="fa fa-plus"></i></a>
						  <a class="remove_file"><i style="font-size: 30px;color: red;" class="fa fa-minus"></i></a>
						  </li>
						</ul>
						<div class="clearfix"></div>
						
						<div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">File <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input style="padding:0px;" id="file" class="form-control col-md-7 col-xs-12 file_input" data-validate-length-range="1" name="files[]" placeholder="" type="file">
                        </div>
                      </div>
					  
					  
					  <hr style="height: 5px; background: black;" >
					  
					  </div>
					  
					  
					  <div class="ln_solid"></div>
                      <div class="form-group">
                        <div class="col-md-6 col-md-offset-3">
                          <button id="send" type="submit" class="btn btn-success">Submit</button>
                        </div>
                      </div>
					  
					  
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /page content -->

@endsection
