@extends($layout)

@section('content')

<!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Edit purchase order</h3>
              </div>

              <div class="title_right" style="visibility: hidden;">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for...">
                    <span class="input-group-btn">
                              <button class="btn btn-default" type="button">Go!</button>
                          </span>
                  </div>
                </div>
              </div>
            </div>
            <div class="clearfix"></div>

			<div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Purchase order Data<small> Please fill all required fields *</small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">

                    <form class="form-horizontal form-label-left" novalidate action="{{ url('/purchase_order_edit') }}" method="post">
					  <input value="{{ $purchase_order->id }}" id="id" name="id" required="required" type="hidden">
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="po_nbr">PO# <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input value="{{ $purchase_order->po_nbr }}" id="po_nbr" class="form-control col-md-7 col-xs-12" data-validate-length-range="6" data-validate-words="1" name="po_nbr" placeholder=""  type="text">
                        </div>
                      </div>
					  
					  
                      <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="order_date">Order date <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input value="{{ $purchase_order->order_date }}" id="order_date" class="form-control col-md-7 col-xs-12" data-validate-length-range="6" data-validate-words="1" name="order_date" placeholder="" required="required" type="date">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="order_date">ETA <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input value="{{ $purchase_order->eta }}" id="eta" class="form-control col-md-7 col-xs-12" data-validate-length-range="6" data-validate-words="1" name="eta" placeholder="" required="required" type="date">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="order_date">Schedule <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <textarea id="schedule" class="form-control col-md-7 col-xs-12" name="schedule" placeholder="" >{{ $purchase_order->schedule }}</textarea>
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="order_date">Notes <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <textarea id="notes" class="form-control col-md-7 col-xs-12"  name="notes" placeholder="" >{{ $purchase_order->notes }}</textarea>
                        </div>
                      </div>
                      
                      <div class="ln_solid"></div>
                      <div class="form-group">
                        <div class="col-md-6 col-md-offset-3">
                          <button id="send" type="submit" class="btn btn-success">Submit</button>
                        </div>
                      </div>
                    </form>
					
				<div class="x_title">
                    <h2>Special Orders List<small> </small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
				  
					<table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th style="width: 30px;" >ID</th>
                          <th>Date</th>
                          <th >Location</th>
                          <th>SKU</th>
                          <th>Vendor</th>
                          <th style="width: 50px;" >Quoted Price</th>
                          <th style="width: 50px;" >Customer Name</th>
                          <th>State</th>
                          <th>Action</th>
                        </tr>
                      </thead>


                      <tbody>
					  
						@foreach ($special_orders as $special_order)
							<tr id="{{ $special_order->id }}" style="" class=""  >
 								<th style="font-size: 16px;" > 
									<label for="check_{{ $special_order->id }}"> {{ $special_order->id }}  </label>
									@if ( Auth::user()->type == "purchasing"  ) <input type="checkbox" class="special_order_checkbox" id="check_{{ $special_order->id }}" status="{{ $special_order->status }}" order_id="{{ $special_order->id }}" > @endif
								</th>
								<td>{{ $special_order->date }}</td>
								<td>{{ $special_order->store_nbr }}</td>
								<td>{{ $special_order->sku }}</td>
								<td>{{ $special_order->vendor_name }}</td>
								<td>{{ $special_order->quoted_price }}</td>
								<td>{{ $special_order->customer_name }}</td>
								<td>{{ $special_order->status }}</td>
								<td>
									<a href="/cancel_order/{{ $special_order->id }}/{{ $purchase_order->id }}" type="button" class="btn btn-default btn-danger btn-xs ">Cancel Order</a>
								</td>
							</tr>
						@endforeach
                      </tbody>
						<tfoot>
							<tr>
								<th >ID</th>
								<th>Date</th>
								<th>Location</th>
								<th>SKU</th>
								<th>Vendor</th>
								<th>SKU</th>
								<th>Customer Name</th>
								<th>State</th>
								<th class='hidden' >Action</th>
							</tr>
						</tfoot>
                    </table>
					
					
                  </div>
                </div>
              </div>
            </div>
			
            
          </div>
        </div>
        <!-- /page content -->

@endsection
