@extends($layout)

@section('content')

<!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Messages <small></small></h3>
              </div>

              <div class="title_right" style="visibility: hidden;">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for...">
                    <span class="input-group-btn">
                      <button class="btn btn-default" type="button">Go!</button>
                    </span>
                  </div>
                </div>
              </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Message's List <small></small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>ID</th>
                          <th>Message</th>
                          <th>Date</th>
                          <th>Active</th>
                          <th class="action" >Action</th>
                        </tr>
                      </thead>


                      <tbody>
					  
						@foreach ($messages as $message)
							<tr id="{{ $message->id }}" style="" class=""  >
 								<th style="font-size: 16px;" > {{ $message->id }} </th>
								<td>{{ $message->message }}</td>
								<td>{{ $message->create_date }}</td>
								<td>
									@if ( $message->active == 1 )
										Enabled
									@else
										Disabled
									@endif
								</td>
								<td>
									<a href="message_edit/{{ $message->id }}" type="button" class="btn btn-default btn-info btn-xs ">Edit</a>
									@if ( $message->active == 1 )
										<a href="message_disable/{{ $message->id }}" type="button" class="btn btn-default btn-danger btn-xs ">Disable</a>
									@else
									<a href="message_enable/{{ $message->id }}" type="button" class="btn btn-default btn-success btn-xs ">Enable</a>
									@endif
								</td>
							</tr>
						@endforeach
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
        <!-- /page content -->

@endsection
