@extends($layout)

@section('content')

<!-- page content -->
        <div class="right_col" role="main">
          <!-- top tiles -->
          <div class="row tile_count" style="display:none;">
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
              <span class="count_top"><i class="fa fa-user"></i> Total Users</span>
              <div class="count">2500</div>
              <span class="count_bottom"><i class="green">4% </i> From last Week</span>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
              <span class="count_top"><i class="fa fa-clock-o"></i> Average Time</span>
              <div class="count">123.50</div>
              <span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>3% </i> From last Week</span>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
              <span class="count_top"><i class="fa fa-user"></i> Total Males</span>
              <div class="count green">2,500</div>
              <span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
              <span class="count_top"><i class="fa fa-user"></i> Total Females</span>
              <div class="count">4,567</div>
              <span class="count_bottom"><i class="red"><i class="fa fa-sort-desc"></i>12% </i> From last Week</span>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
              <span class="count_top"><i class="fa fa-user"></i> Total Collections</span>
              <div class="count">2,315</div>
              <span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>
            </div>
            <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
              <span class="count_top"><i class="fa fa-user"></i> Total Connections</span>
              <div class="count">7,325</div>
              <span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>
            </div>
          </div>
          <!-- /top tiles -->

          <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
              <div class="dashboard_graph" style="display:none;" >

                <div class="row x_title">
                  <div class="col-md-6">
                    <h3>Activity over the past four weeks <small></small></h3>
                  </div>
                  <div class="col-md-6" style="display: none;" >
                    <div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                      <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                      <span>December 30, 2014 - January 28, 2015</span> <b class="caret"></b>
                    </div>
                  </div>
                </div>

                <div class="col-md-12 col-sm-12 col-xs-12">
				  <canvas id="chart_plot_main" class="demo-placeholder"></canvas>
                </div>
                <div style="display:none;" class="col-md-3 col-sm-3 col-xs-12 bg-white">
                  <div class="x_title">
                    <h2>Top Campaign Performance</h2>
                    <div class="clearfix"></div>
                  </div>

                  <div class="col-md-12 col-sm-12 col-xs-6">
                    <div>
                      <p>Facebook Campaign</p>
                      <div class="">
                        <div class="progress progress_sm" style="width: 76%;">
                          <div class="progress-bar bg-green" role="progressbar" data-transitiongoal="80"></div>
                        </div>
                      </div>
                    </div>
                    <div>
                      <p>Twitter Campaign</p>
                      <div class="">
                        <div class="progress progress_sm" style="width: 76%;">
                          <div class="progress-bar bg-green" role="progressbar" data-transitiongoal="60"></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12 col-sm-12 col-xs-6">
                    <div>
                      <p>Conventional Media</p>
                      <div class="">
                        <div class="progress progress_sm" style="width: 76%;">
                          <div class="progress-bar bg-green" role="progressbar" data-transitiongoal="40"></div>
                        </div>
                      </div>
                    </div>
                    <div>
                      <p>Bill boards</p>
                      <div class="">
                        <div class="progress progress_sm" style="width: 76%;">
                          <div class="progress-bar bg-green" role="progressbar" data-transitiongoal="50"></div>
                        </div>
                      </div>
                    </div>
                  </div>

                </div>

                <div class="clearfix"></div>
              </div>
            </div>

          </div>
          <br />

          <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title" style="display:none;">
                    <h2>Special_order's List <small></small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
							<th>ID</th>
							<th style="width:110px;">Date</th>
							<th style="width:100px;">Purchasing PO#</th>
							<th style="width:80px;">Location</th>
							<th>Vendor</th>
							<th>Quantities</th>
							<th>SKU</th>
							<th>Item Description</th>
							<th >Comments</th>
							<th>State</th>
							<th >Actions</th>
                        </tr>
                      </thead>


                      <tbody>
					  
						@foreach ($special_orders as $special_order)
							<tr id="{{ $special_order->id }}" style="" class=""  >
 								<th style="font-size: 16px;" > 
									<label for="check_{{ $special_order->id }}"> {{ $special_order->id }}  </label>
									@if ( Auth::user()->type == "purchasing"  ) <input type="checkbox" class="special_order_checkbox" id="check_{{ $special_order->id }}" status="{{ $special_order->status }}" order_id="{{ $special_order->id }}" > @endif
								</th>
								<td>{{ $special_order->date }}</td>
								<td>{{ $special_order->po_nbr }}</td>
								<td>{{ $special_order->store_nbr }}</td>
								<td>{{ $special_order->vendor_name }}</td>
								<td>{{ $special_order->qty }}</td>
								<td>{{ $special_order->sku }}</td>
								<td>{{ $special_order->description }}</td>
								<td>{{ $special_order->comments }}</td>
								
								<td style="color:  @if ( $special_order->status == "waiting"  ) blue @endif @if ( $special_order->status == "ordered" || $special_order->status == "received"  ) green @endif @if ( $special_order->status == "canceled"  ) red @endif ; @if ( $special_order->status == "received"  ) text-shadow: 0 0 3px #18FF00, 0 0 5px #00FF30; @endif" >
									{{ $special_order->status }}
								</td>
								<td   >
									<a href="{!! url('/special_order_edit/'.$special_order->id) !!}" type="button" class="btn btn-default btn-info btn-xs ">Edit</a>
									@if ( $special_order->status  == "waiting"  ) <a href="{!! url('/cancel_order/'.$special_order->id) !!}" type="button" class="btn btn-default btn-danger btn-xs ">Cancel</a> @endif 
								</td>
							</tr>
						@endforeach
                      </tbody>
						<tfoot>
							<tr>
								<th >ID</th>
								<th>Date</th>
								<th>Purchasing PO#</th>
								<th>Location</th>
								<th>Vendor</th>
								<th>Quantities</th>
								<th>SKU</th>
								<th>Item Description</th>
								<th style="width: 50px;" >Comments</th>
								<th>State</th>
								<th >Action</th>
							</tr>
						</tfoot>
                    </table>
					
					<script>
					$( document ).ready(function() {
						var date_labels = {!! $created_SO_count->toJson() !!} ;
						date_labels = date_labels.map(a => a.date);
						
						var created_data = {!! $created_SO_count->toJson() !!} ;
						created_data = created_data.map(a => a.count);
						
						var ordered_data = {!! $ordered_SO_count->toJson() !!} ;
						ordered_data = ordered_data.map(a => a.count);
						
						var canceled_data = {!! $canceled_SO_count->toJson() !!} ;
						canceled_data = canceled_data.map(a => a.count);
						
						var received_data = {!! $received_SO_count->toJson() !!} ;
						received_data = received_data.map(a => a.count);
						
						// alert ( JSON.stringify(created_data) );
						// Line chart
						 
						if ($('#chart_plot_main').length ){	
						
						  var ctx = document.getElementById("chart_plot_main");
						  ctx.height = 70;
						  var chart_plot_main = new Chart(ctx, {
							type: 'line',
							data: {
							  labels: date_labels,
							  datasets: [{
								label: "Created SO",
								backgroundColor: "rgba(38, 185, 154, 0.31)",
								borderColor: "rgba(16, 84, 36, 0.7)",
								pointBorderColor: "rgba(38, 185, 154, 0.7)",
								pointBackgroundColor: "rgba(38, 185, 154, 0.7)",
								pointHoverBackgroundColor: "#fff",
								pointHoverBorderColor: "rgba(220,220,220,1)",
								pointBorderWidth: 1,
								data: created_data
							  }, {
								label: "Ordered SO",
								backgroundColor: "rgba(3, 88, 106, 0.3)",
								borderColor: "rgba(0, 0, 190, 0.70)",
								pointBorderColor: "rgba(3, 88, 106, 0.70)",
								pointBackgroundColor: "rgba(3, 88, 106, 0.70)",
								pointHoverBackgroundColor: "#fff",
								pointHoverBorderColor: "rgba(151,187,205,1)",
								pointBorderWidth: 1,
								data: ordered_data
							  }, {
								label: "Canceled SO",
								backgroundColor: "rgba(255, 70, 70, 0.70)",
								borderColor: "rgba(255, 0, 0, 0.70)",
								pointBorderColor: "rgba(255, 70, 70, 0.70)",
								pointBackgroundColor: "rgba(255, 70, 70, 0.70)",
								pointHoverBackgroundColor: "#fff",
								pointHoverBorderColor: "rgba(151,187,205,1)",
								pointBorderWidth: 1,
								data: canceled_data
							  }, {
								label: "Received SO",
								backgroundColor: "rgba(0, 255, 0, 0.70)",
								borderColor: "rgba(43, 215, 43, 0.70)",
								pointBorderColor: "rgba(0, 255, 0, 0.70)",
								pointBackgroundColor: "rgba(0, 255, 0, 0.70)",
								pointHoverBackgroundColor: "#fff",
								pointHoverBorderColor: "rgba(151,187,205,1)",
								pointBorderWidth: 1,
								data: received_data
							  }
							  ]
							},
						  });
						
						}
						window.is_purchasing_home = true;
					});
					</script>
					@if ( Auth::user()->type == "purchasing"  ) 
						<!-- bulk actions -->
						@include('bulk_action')
					@endif
					
                    
					
                  </div>
				  
				  
				  
                </div>
              </div>

            </div>
			
          

          
        </div>
        <!-- /page content -->
		
		
		
@endsection
