@extends($layout)

@section('content')

<!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Counts <small></small></h3>
              </div>

              <div class="title_right" style="visibility: hidden;">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for...">
                    <span class="input-group-btn">
                      <button class="btn btn-default" type="button">Go!</button>
                    </span>
                  </div>
                </div>
              </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Count's List <small></small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">
                    <table id="datatable-buttons" class="table table-striped table-bordered">
                      <thead>
                        <tr>
                          <th>ID</th>
                          <th>SKU #</th>
                          <th>Count</th>
                          <th>Date</th>
                          <th>User</th>
                          <th>Store #</th>
                          <th class="action" >Action</th>
                        </tr>
                      </thead>


                      <tbody>
					  
						@foreach ($counts as $count)
							<tr id="{{ $count->id }}" style="" class=""  >
 								<th style="font-size: 16px;" > {{ $count->id }} </th>
								<td>{{ $count->name }}</td>
								<td>{{ $count->value }}</td>
								<td>{{ $count->date }}</td>
								<td>{{ $count->user_name }}</td>
								<td>{{ $count->store_nbr }}</td>
								
								<td>
									<a href="{{ url('/count/edit/'.$count->id)}}" type="button" class="btn btn-default btn-info btn-xs ">Edit</a>
								</td>
							</tr>
						@endforeach
                      </tbody>
					  
					  <tfoot>
							<tr>
								<th>ID</th>
								<th>SKU #</th>
								<th>Count</th>
								<th>Date</th>
								<th>User</th>
								<th>Store #</th>
								<th class='hidden' >Action</th>
							</tr>
					  </tfoot>
						
                    </table>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
        <!-- /page content -->

@endsection
