@extends($layout)

@section('content')

<!-- page content -->
        <div class="right_col" role="main">
          <div class="">
            <div class="page-title">
              <div class="title_left">
                <h3>Add new count</h3>
              </div>

              <div class="title_right" style="visibility: hidden;">
                <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                  <div class="input-group">
                    <input type="text" class="form-control" placeholder="Search for...">
                    <span class="input-group-btn">
                              <button class="btn btn-default" type="button">Go!</button>
                          </span>
                  </div>
                </div>
              </div>
            </div>
            <div class="clearfix"></div>

            <div class="row">
              <div class="col-md-12 col-sm-12 col-xs-12">
                <div class="x_panel">
                  <div class="x_title">
                    <h2>Count Data<small> Please fill all required fields *</small></h2>
                    <ul class="nav navbar-right panel_toolbox">
                      <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                      </li>
                    </ul>
                    <div class="clearfix"></div>
                  </div>
                  <div class="x_content">

                    <form id="form" class="form-horizontal form-label-left" novalidate action="{{ url('/count/add')}}" method="post">

					<input id="sku_id" name="sku_id" required="required" type="hidden">
					<input id="store_id" name="store_id" value="{{$store_id}}" required="required" type="hidden">
                      <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="count_nbr">Store # <span class="required"></span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input id="store" value="{{$store_name}}" disabled class="form-control col-md-7 col-xs-12" data-validate-length-range="1" required="required" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="count_nbr">SKU # <span class="required">*</span>
                        </label>
                        <div class="col-md-5 col-sm-5 col-xs-8">
                          <input id="sku_name" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" type="text">
                        </div>
						<div class="col-md-1 col-sm-1 col-xs-4">
                          <button id="check" class="btn btn-success">Check</button>
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Description <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input disabled id="description" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="description" required="required" type="text">
                        </div>
                      </div>
					  
					  <div class="item form-group">
                        <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Count <span class="required">*</span>
                        </label>
                        <div class="col-md-6 col-sm-6 col-xs-12">
                          <input form="form" id="value" class="form-control col-md-7 col-xs-12" data-validate-length-range="1" name="value" required="required" type="text">
                        </div>
                      </div>
                      
                      <div class="ln_solid"></div>
                      <div class="form-group">
                        <div class="col-md-6 col-md-offset-3">
                          <button disabled id="send" type="submit" class="btn btn-success">Submit</button>
                        </div>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- /page content -->

<script>
	$( document ).ready(function() { 
	
	$('#sku_name').focus();
	function check_sku( event) {
			event.preventDefault();
			var data_obj = {};
			data_obj.name = $("#sku_name").val();
			
			console.log(data_obj);
			$.ajax({
				url: '{{ url("/sku/check")}}',
				type: 'POST',
				data: data_obj,
				async:false,
				success: function(data) {
					if(data.success === true){
						$("#description").val(data.description);
						$("#sku_id").val(data.id);
						$('#send').attr("disabled", false);	
						$('#value').focus();	
					}
					else
					{
						$("#description").val("");
						$("#sku_id").val("");
						$('#send').attr("disabled", true);	
					}
				}
			});
	}
	
	$( "#check" ).click(function( event ) {
		
		check_sku(event);
	});
	
	$('#sku_name').keypress(function(event){
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13'){
			check_sku(event);
		}

	});
	
	$('#value').keypress(function(event){
		
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13'){
			event.preventDefault();
			$('#form').submit();
		}

	});


	});
</script>
@endsection
