<br><br>
<div class="item form-group" style="margin-top:20px;" >
    
    <div class="col-md-2 col-sm-2 col-xs-3">
	  <select class="form-control" id="bulk_actions" >
		<option selected="true" disabled="disabled" value="id"> Bulk Action </option>
		<option value="add_order"> Add to Purchasing Order </option>
		<option value="edit_order"> Assign to another Purchasing Order </option>
		<option value="received_order"> Received Special Order </option>
		<option value="cancel_order"> Cancel Special Order </option>
	  </select>
    </div>
	<button id="bulk_action" type="button" class="btn btn-success"> Execute </button>
</div>
<script>

 $( document ).ready(function() {
			
			
			
			$( "#bulk_action" ).on( "click", function() {
				
				if ( $( "#bulk_actions" ).val() == null )
				{
					$.alert({
						title: '',
						content: 'Select a bulk action',
					});
					return 0;
				}
				
				if ( $('.special_order_checkbox:checkbox:checked').length == 0 )
				{
					$.alert({
						title: '',
						content: 'Select at least one order',
					});
					return 0;
				}
				
				
				var order_ids = [];
				var already_ordered_count = 0;
				var already_canceled_count = 0;
				var already_received_count = 0;
				var checked_count = 0;
				$('.special_order_checkbox:checkbox:checked').each(function () { 
					checked_count ++ ;
					order_ids.push( $(this).attr("order_id") );
					if ( $(this).attr("status") == "ordered" )
						already_ordered_count++;
					else if ( $(this).attr("status") == "canceled" )
						already_canceled_count++;
					else if ( $(this).attr("status") == "received" )
						already_received_count++;
				});
					
				if ( $( "#bulk_actions" ).val() == "add_order" )
				{
					
					
					if ( already_ordered_count != 0 || already_canceled_count != 0 )
					{
						$.alert({
							title: '',
							content: ( already_ordered_count + already_canceled_count ) + ' of the selected items are already ordered or canceled!',
						});
						return 0;
					}
					
					$.confirm({
						title: 'Bulk action: add to purchasing order!',
						content: '' +
						'<form novalidate action="" class="form-horizontal form-label-left"  style="width: 100%; display: inline-block;">' +
						'<div class="item form-group">' +
						'<label>Order Date</label>' +
						'<input type="date" class="form-control" name="order_date"  />' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label> ETA </label>' +
						'<input type="date" class="form-control" name="eta" />' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label> Vendor Order schedule </label>' +
						'<textarea class="form-control" name="schedule" ></textarea>' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label> Notes </label>' +
						'<textarea class="form-control" name="notes" ></textarea>' +
						'</div>' +
						
						'<br> ' +
						'<div class="item form-group">' +
						'<label> Or choose an already created purchasing order </label>' +
						'<select class="form-control" id="purchasing_order_id" name="purchasing_order_id" >' +
						'<option value="" > Purchasing Order </option>' +
						' @foreach ($purchase_orders as $po) <option value="{{ $po->id }}">{{ $po->po_nbr }}</option> @endforeach ' +
						
						'</select>' +
						'</div>' +
						
						'</form>',
						buttons: {
							formSubmit: {
								text: 'Submit',
								btnClass: 'btn-blue',
								action: function () {
									counter = 0; 
									var data = {};
									if ( this.$content.find('#purchasing_order_id').val() == "" )
									{
										this.$content.find('input, textarea').each(function () {
											if ( $(this).val() == "" && $(this).attr("name") != "schedule" && $(this).attr("name") != "notes" )
												counter ++;
											
											if ( $(this).attr("id") != "purchasing_order_id" )
												data[ $(this).attr("name") ] = $(this).val();
										});
									}
									else
									{
										data[ 'purchasing_order_id' ] = this.$content.find('#purchasing_order_id').val();
									}
									
									data['order_ids'] = order_ids;
									// alert(JSON.stringify(data));
									
									if ( counter != 0 )
									{
										$.alert('Please fill all required fields');
										return false;
									}
									
									var saveData = $.ajax({
										  type: 'POST',
										  url: "{!! url('/add_orders_to_purchase_order/') !!}",
										  data: data,
										  // dataType: "text",
										  success: function(resultData) { 
											if ( resultData.success == true)
											{
												$.alert({
													title: '',
													content: 'bulk action complete',
												});
												location.reload(false)
											}
										  }
									});
									saveData.error(function() { alert("Something went wrong"); });
									
								}
							},
							cancel: function () {
								//close
							},
						},
						onContentReady: function () {
							// bind to events
							var jc = this;
							this.$content.find('form').on('submit', function (e) {
								// if the user submits the form by pressing enter in the field.
								e.preventDefault();
								jc.$$formSubmit.trigger('click'); // reference the button and click it
							});
						}
					});
				}
				else if ( $( "#bulk_actions" ).val() == "edit_order" )
				{
					
					
					if (  already_canceled_count != 0 || already_ordered_count == 0 )
					{
						$.alert({
							title: '',
							content: ( checked_count - already_ordered_count + already_canceled_count - 1 ) + ' of the selected items are already canceled or not ordered!',
						});
						return 0;
					}
					
					$.confirm({
						title: 'Bulk action: Assign to another purchasing order!',
						content: '' +
						'<form novalidate action="" class="form-horizontal form-label-left"  style="width: 100%; display: inline-block;">' +
						
						'<div class="item form-group">' +
						'<label>PO#</label>' +
						'<input type="text" class="form-control" name="po_nbr"  />' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label>Order Date</label>' +
						'<input type="date" class="form-control" name="order_date"  />' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label> ETA </label>' +
						'<input type="date" class="form-control" name="eta" />' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label> Vendor Order schedule </label>' +
						'<textarea class="form-control" name="schedule" ></textarea>' +
						'</div>' +
						
						'<div class="item form-group">' +
						'<label> Notes </label>' +
						'<textarea class="form-control" name="notes" ></textarea>' +
						'</div>' +
						
						'<br> ' +
						'<div class="item form-group">' +
						'<label> Or choose an already created purchasing order </label>' +
						'<select class="form-control" id="purchasing_order_id" name="purchasing_order_id" >' +
						'<option value="" > Purchasing Order </option>' +
						' @foreach ($purchase_orders as $po) <option value="{{ $po->id }}">{{ $po->po_nbr }}</option> @endforeach ' +
						
						'</select>' +
						'</div>' +
						
						'</form>',
						buttons: {
							formSubmit: {
								text: 'Submit',
								btnClass: 'btn-blue',
								action: function () {
									counter = 0; 
									var data = {};
									if ( this.$content.find('#purchasing_order_id').val() == "" )
									{
										this.$content.find('input, textarea').each(function () {
											if ( $(this).val() == "" && $(this).attr("name") != "schedule" && $(this).attr("name") != "notes" )
												counter ++;
											
											if ( $(this).attr("id") != "purchasing_order_id" )
												data[ $(this).attr("name") ] = $(this).val();
										});
									}
									else
									{
										data[ 'purchasing_order_id' ] = this.$content.find('#purchasing_order_id').val();
									}
									
									data['order_ids'] = order_ids;
									// alert(JSON.stringify(data));
									
									if ( counter != 0 )
									{
										$.alert('Please fill all required fields');
										return false;
									}
									
									var saveData = $.ajax({
										  type: 'POST',
										  url: "{!! url('/add_orders_to_purchase_order/') !!}",
										  data: data,
										  // dataType: "text",
										  success: function(resultData) { 
											if ( resultData.success == true)
											{
												$.alert({
													title: '',
													content: 'bulk action complete',
												});
												location.reload(false)
											}
										  }
									});
									saveData.error(function() { alert("Something went wrong"); });
									
								}
							},
							cancel: function () {
								//close
							},
						},
						onContentReady: function () {
							// bind to events
							var jc = this;
							this.$content.find('form').on('submit', function (e) {
								// if the user submits the form by pressing enter in the field.
								e.preventDefault();
								jc.$$formSubmit.trigger('click'); // reference the button and click it
							});
						}
					});
				}
				else if ( $( "#bulk_actions" ).val() == "received_order" )
				{
					
					if ( already_ordered_count != checked_count )
					{
						$.alert({
							title: '',
							content: ( checked_count - already_ordered_count ) + ' of the selected items are not "ordered" !',
						});
						return 0;
					}
					
					$.confirm({
						title: 'Bulk action: Received orders !',
						content: '' +
						'<form novalidate action="" class="form-horizontal form-label-left"  style="width: 100%; display: inline-block;">' +
						'<label> Are you sure you want to set ' + already_ordered_count + ' orders as "recveived" :</label><br>'+
						'</form>',
						buttons: {
							formSubmit: {
								text: 'Submit',
								btnClass: 'btn-blue',
								action: function () {
									var data = {};
									data['order_ids'] = order_ids;
									// alert(JSON.stringify(data));
									
									
									var saveData = $.ajax({
										  type: 'POST',
										  url: "{!! url('/receive_orders/') !!}",
										  data: data,
										  // dataType: "text",
										  success: function(resultData) { 
											if ( resultData.success == true)
											{
												$.alert({
													title: '',
													content: 'bulk action complete',
												});
												location.reload(false)
											}
										  }
									});
									saveData.error(function() { alert("Something went wrong"); });
									
								}
							},
							cancel: function () {
								//close
							},
						},
						onContentReady: function () {
							// bind to events
							var jc = this;
							this.$content.find('form').on('submit', function (e) {
								// if the user submits the form by pressing enter in the field.
								e.preventDefault();
								jc.$$formSubmit.trigger('click'); // reference the button and click it
							});
						}
					});
				}
				else if ( $( "#bulk_actions" ).val() == "cancel_order" )
				{
					if ( already_canceled_count != 0 || already_received_count != 0 )
					{
						$.alert({
							title: '',
							content: ( already_canceled_count + already_received_count ) + ' of the selected items are already canceled or received!',
						});
						return 0;
					}
					
					$.confirm({
						title: 'Bulk action: Cancel orders!',
						content: '' +
						'<form novalidate action="" class="form-horizontal form-label-left"  style="width: 100%; display: inline-block;">' +
						'<label> Are you sure you want to cancel :</label><br>'+
						'<label> '+already_ordered_count+' orders already registered to a purchasing order </label><br>'+
						'<label> '+( order_ids.length - already_ordered_count - already_canceled_count)+' waiting orders </label>'+
						'</form>',
						buttons: {
							formSubmit: {
								text: 'Submit',
								btnClass: 'btn-blue',
								action: function () {
									var data = {};
									data['order_ids'] = order_ids;
									// alert(JSON.stringify(data));
									
									
									var saveData = $.ajax({
										  type: 'POST',
										  url: "{!! url('/cancel_orders/') !!}",
										  data: data,
										  // dataType: "text",
										  success: function(resultData) { 
											if ( resultData.success == true)
											{
												$.alert({
													title: '',
													content: 'bulk action complete',
												});
												location.reload(false)
											}
										  }
									});
									saveData.error(function() { alert("Something went wrong"); });
									
								}
							},
							cancel: function () {
								//close
							},
						},
						onContentReady: function () {
							// bind to events
							var jc = this;
							this.$content.find('form').on('submit', function (e) {
								// if the user submits the form by pressing enter in the field.
								e.preventDefault();
								jc.$$formSubmit.trigger('click'); // reference the button and click it
							});
						}
					});
				}
				
			});
			
		});
</script>