<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

use Illuminate\Database\Eloquent\Model;
use DB;

class User extends Authenticatable
{
    use Notifiable;

	protected $table = 'users';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
	
	public static function get_users( )
    {
		$users = DB::table('users as v')
				->select('v.*')
				->get();
		
		return $users;
    }

	
	public static function get_user_store(  )
    {
		$data['user_id'] = auth()->id();
		
		$store = DB::table('users as u')
				->select('store.*')
				->leftJoin('store', 'store.id', '=', 'u.store_id')
				->where('u.id', $data['user_id'] )
				->first();
				
		return $store;
    }
	
	public static function add_user( $data )
    {
		// $data['user_id'] = auth()->id();
		
		if ( $data['type'] != "employee" )
		{
			$data['store_id'] = null;
			$data['employee_nbr'] = null;
		}
		$user = new \App\User();
		$data['password'] = \Hash::make( $data['password'] );

		$users = DB::table('users')
				->insert(
					$data
				);
		// $user = self::create($data);

		return true;
    }
	
	public static function edit_user( $data )
    {
		if ( $data['type'] != "employee" )
		{
			$data['store_id'] = null;
			$data['employee_nbr'] = null;
		}
		
		if ( $data['password'] == "" )
		{
			unset ( $data['password'] );
		}
		else
		{
			$user = new \App\User();
			$data['password'] = \Hash::make( $data['password'] );
		}
		
		$users = DB::table('users')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_user( $id )
    {
		$data['active'] = 0;
		$users = DB::table('users')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_user( $id )
    {
		$data['active'] = 1;
		$users = DB::table('users')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_user_by_id( $id )
    {	
    	$user = DB::table('users as v')
				->select('v.*')
				->where('id',$id)
				->first();
				// ->get();
		
		return $user;
    }
}
