<?php

namespace App\Models;

// use App\Models\ProjectUser;
use Illuminate\Database\Eloquent\Model;
use DB;

class Vendor extends Model
{
    
	protected $table = 'vendor';
    protected $fillable = [ 'id', 'name' ];
	
	public static function get_vendors( )
    {
		$vendors = DB::table('vendor as v')
				->select('v.*')
				->orderBy('name', 'asc')
				->get();
		
		return $vendors;
    }

	
	public static function add_vendor( $data )
    {
		// $data['user_id'] = auth()->id();
		
		$vendors = DB::table('vendor')
				->insert(
					$data
				);
		// $vendor = self::create($data);

		return true;
    }
	
	public static function edit_vendor( $data )
    {
		$vendors = DB::table('vendor')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_vendor( $id )
    {
		$data['active'] = 0;
		$vendors = DB::table('vendor')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_vendor( $id )
    {
		$data['active'] = 1;
		$vendors = DB::table('vendor')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_vendor_by_id( $id )
    {	
    	$vendor = DB::table('vendor as v')
				->select('v.*')
				->where('id',$id)
				->first();
				// ->get();
		
		return $vendor;
    }
	
}
