<?php

namespace App\Models;

// use App\Models\ProjectUser;
use Illuminate\Database\Eloquent\Model;
use DB;

class Special_order extends Model
{
    
	protected $table = 'special_order';
    protected $fillable = [ 'id', 'date', 'qty', 'cat', 'sku', 'description', 'net_price', 'quoted_price', 'customer_name', 'home_phone', 'word_phone', 'address', 'city', 'province', 'postal_code', 'company', 'customer_nbr', 'comments', 'call1', 'call2', 'call3', 'rush', 'need_by_date', 'salesperson_id', 'vendor_id', 'pre_payment', 'status', 'status_date', 'staff_id' ];
	protected $dates = [ 'cancel_date', 'received_date', 'ordered_date' ];
	
	public static function get_special_orders( $four_weeks = false , $order_status = "")
    {	
		// print_r(auth()->user()->type );
		// die ( "***" );
		$special_orders = DB::table('special_order as so')
				->leftJoin('vendor as v', 'so.vendor_id', '=', 'v.id')
				->leftJoin('users as u', 'so.salesperson_id', '=', 'u.id')
				->leftJoin('store as s', 'u.store_id', '=', 's.id')
				
				->leftJoin('purchase_order_special_order as poso', 'so.id', '=', 'poso.special_order_id')
				->leftJoin('purchase_order as po', 'po.id', '=', 'poso.purchase_order_id')
				->where('so.status', 'like', '%' . $order_status . '%')
				->select('so.*', 'v.name as vendor_name', 's.store_nbr as store_nbr', 'po_nbr');
				
		if ( auth()->user()->type != "admin" && auth()->user()->type != "purchasing" && auth()->user()->type != "e_store"  )
		{
			$store_id = DB::table('users as u')
						->leftJoin('store as s', 'u.store_id', '=', 's.id')
						->where('u.id' , auth()->id() )
						->select('store_id')
						->first()->store_id;
						
			$special_orders->where('u.store_id' , $store_id );
		}
		
		if ( $four_weeks == true)
			$special_orders->whereRaw ( ' DATE(so.date) between DATE(NOW()) + INTERVAL -1 MONTH and DATE(NOW()) '  );

		// $special_orders = $special_orders->get();
		$special_orders = $special_orders->get();
		return $special_orders;
    }

	
	public static function add_special_order( $data )
    {
		if ( ! isset( $data['salesperson_id'] ) )
			$data['salesperson_id'] = auth()->id();
		
		$special_orders = DB::table('special_order')
				->insertGetId(
					$data
				);
		
		
		// $special_order = self::create($data);

		return $special_orders;
    }
	
	public static function edit_special_order( $data )
    {
		$special_orders = DB::table('special_order')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_special_order( $id )
    {
		$data['active'] = 0;
		$special_orders = DB::table('special_order')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_special_order( $id )
    {
		$data['active'] = 1;
		$special_orders = DB::table('special_order')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_special_order_by_id( $id )
    {	
    	$special_order = DB::table('special_order as so')
				->leftJoin('vendor as v', 'so.vendor_id', '=', 'v.id')
				->leftJoin('purchase_order_special_order as poso', 'so.id', '=', 'poso.special_order_id')
				->leftJoin('purchase_order as po', 'po.id', '=', 'poso.purchase_order_id')
				->leftJoin('users as u', 'so.salesperson_id', '=', 'u.id')
				->leftJoin('store as s', 'u.store_id', '=', 's.id')
				->select('so.*', 'po.id as po_id', 'po.eta', 'po.po_nbr', 'so.date', 'po.order_date', 'po.schedule', 'po.notes', 's.store_nbr as store_nbr', 'v.name as vendor')
				->where('so.id',$id)
				->first();
				// ->get();
		
		return $special_order;
    }
	
	///////////////// Reports /////////////////
	
	public static function get_created_SO_count()
    {	
		$dates_sql = "( select a.Date from ( select curdate() - INTERVAL (a.a + (10 * b.a) + (100 * c.a)) DAY as Date    from (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as c) a	where a.Date between DATE(NOW()) + INTERVAL -1 MONTH and DATE(NOW()) ) as dates";
		
		if ( auth()->user()->type != "admin" && auth()->user()->type != "purchasing" && auth()->user()->type != "e_store" )
		{
			$created_SO_sql = "( select `so`.*  from `special_order` as `so` left join `vendor` as `v` on `so`.`vendor_id` = `v`.`id` left join `users` as `u` on `so`.`salesperson_id` = `u`.`id` left join `store` as `s` on `u`.`store_id` = `s`.`id` where `u`.`store_id` = 2 AND so.status like '%' ) as special_order";
		}
		else
		{
			$created_SO_sql = "( select * from special_order where status like '%' ) as special_order";
		}
		
		$created_SO_count = DB::table( \DB::raw($created_SO_sql) )
				->rightJoin( \DB::raw($dates_sql) , \DB::raw( 'date(special_order.date)' ), '=', \DB::raw( 'dates.date' ) )
				->select( \DB::raw( 'count( special_order.date ) as count' ), \DB::raw( "DATE_FORMAT(dates.date,'%b %d') as date" ))
				->groupBy( \DB::raw( 'dates.date' ) )
				// ->where('id',$id)
				->get();
		
		return $created_SO_count;
    }
	
	public static function get_ordered_SO_count()
    {	
		$dates_sql = "( select a.Date from ( select curdate() - INTERVAL (a.a + (10 * b.a) + (100 * c.a)) DAY as Date    from (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as c) a	where a.Date between DATE(NOW()) + INTERVAL -1 MONTH and DATE(NOW()) ) as dates";
    	
		if ( auth()->user()->type != "admin" && auth()->user()->type != "purchasing" && auth()->user()->type != "e_store" )
		{
			$ordered_SO_sql = "( select `so`.*  from `special_order` as `so` left join `vendor` as `v` on `so`.`vendor_id` = `v`.`id` left join `users` as `u` on `so`.`salesperson_id` = `u`.`id` left join `store` as `s` on `u`.`store_id` = `s`.`id` where `u`.`store_id` = 2 AND so.status = 'ordered' ) as special_order";
		}
		else
		{
			$ordered_SO_sql = "( select * from special_order where status = 'ordered' ) as special_order";
		}
		
		$created_SO_count = DB::table( \DB::raw($ordered_SO_sql) )
				->rightJoin( \DB::raw($dates_sql) , \DB::raw( 'date(special_order.ordered_date)' ), '=', \DB::raw( 'dates.date' ) )
				->select( \DB::raw( 'count( special_order.ordered_date ) as count' ), \DB::raw( "DATE_FORMAT(dates.date,'%b %d') as date" ))
				->groupBy( \DB::raw( 'dates.date' ) )
				// ->where('id',$id)
				->get();
		
		return $created_SO_count;
    }
	
	public static function get_canceled_SO_count()
    {	
		$dates_sql = "( select a.Date from ( select curdate() - INTERVAL (a.a + (10 * b.a) + (100 * c.a)) DAY as Date    from (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as c) a	where a.Date between DATE(NOW()) + INTERVAL -1 MONTH and DATE(NOW()) ) as dates";
    	
		if ( auth()->user()->type != "admin" && auth()->user()->type != "purchasing" && auth()->user()->type != "e_store" )
		{
			$ordered_SO_sql = "( select `so`.*  from `special_order` as `so` left join `vendor` as `v` on `so`.`vendor_id` = `v`.`id` left join `users` as `u` on `so`.`salesperson_id` = `u`.`id` left join `store` as `s` on `u`.`store_id` = `s`.`id` where `u`.`store_id` = 2 AND so.status = 'canceled' ) as special_order";
		}
		else
		{
			$ordered_SO_sql = "( select * from special_order where status = 'canceled' ) as special_order";
		}
		
		$created_SO_count = DB::table( \DB::raw($ordered_SO_sql) )
				->rightJoin( \DB::raw($dates_sql) , \DB::raw( 'date(special_order.cancel_date)' ), '=', \DB::raw( 'dates.date' ) )
				->select( \DB::raw( 'count( special_order.cancel_date ) as count' ), \DB::raw( "DATE_FORMAT(dates.date,'%b %d') as date" ))
				->groupBy( \DB::raw( 'dates.date' ) )
				// ->where('id',$id)
				->get();
		
		return $created_SO_count;
    }
	
	
	public static function get_received_SO_count()
    {	
		$dates_sql = "( select a.Date from ( select curdate() - INTERVAL (a.a + (10 * b.a) + (100 * c.a)) DAY as Date    from (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as a    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as b    cross join (select 0 as a union all select 1 union all select 2 union all select 3 union all select 4 union all select 5 union all select 6 union all select 7 union all select 8 union all select 9) as c) a	where a.Date between DATE(NOW()) + INTERVAL -1 MONTH and DATE(NOW()) ) as dates";
    	
		if ( auth()->user()->type != "admin" && auth()->user()->type != "purchasing" && auth()->user()->type != "e_store" )
		{
			$ordered_SO_sql = "( select `so`.*  from `special_order` as `so` left join `vendor` as `v` on `so`.`vendor_id` = `v`.`id` left join `users` as `u` on `so`.`salesperson_id` = `u`.`id` left join `store` as `s` on `u`.`store_id` = `s`.`id` where `u`.`store_id` = 2 AND so.status = 'received' ) as special_order";
		}
		else
		{
			$ordered_SO_sql = "( select * from special_order where status = 'received' ) as special_order";
		}
		
		$created_SO_count = DB::table( \DB::raw($ordered_SO_sql) )
				->rightJoin( \DB::raw($dates_sql) , \DB::raw( 'date(special_order.received_date)' ), '=', \DB::raw( 'dates.date' ) )
				->select( \DB::raw( 'count( special_order.received_date ) as count' ), \DB::raw( "DATE_FORMAT(dates.date,'%b %d') as date" ))
				->groupBy( \DB::raw( 'dates.date' ) )
				// ->where('id',$id)
				->get();
		
		return $created_SO_count;
    }
	
	
	///////////////// Reports END /////////////////
	
}
