<?php

namespace App\Models;

// use App\Models\ProjectUser;
use Illuminate\Database\Eloquent\Model;
use DB;

class Sku extends Model
{
    
	protected $table = 'sku';
    protected $fillable = [ 'id', 'name' ];
	
	public static function get_skus( )
    {
		$skus = DB::table('sku as v')
				->select('v.*')
				->get();
		
		return $skus;
    }
	
	public static function get_skus_count_by_name( $name )
    {
		$counter = DB::table('sku as s')
				->select(  DB::raw('count(*) as counter '))
				->where('name',$name)
				->first();
				
		return $counter->counter ;
				
		
    }

	public static function get_sku_by_name( $name )
    {
		$sku = DB::table('sku as s')
				->select( '*' )
				->where('name',$name)
				->first();
				
		return $sku ;
				
		
    }
	
	public static function add_sku( $data )
    {
		// $data['user_id'] = auth()->id();
		
		$skus = DB::table('sku')
				->insert(
					$data
				);
		// $sku = self::create($data);

		return true;
    }
	
	public static function edit_sku( $data )
    {
		$skus = DB::table('sku')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	public static function edit_sku_by_name( $data )
    {
		$skus = DB::table('sku')
				->where('name', 'like' , (string) $data["name"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_sku( $id )
    {
		$data['active'] = 0;
		$skus = DB::table('sku')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_sku( $id )
    {
		$data['active'] = 1;
		$skus = DB::table('sku')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_sku_by_id( $id )
    {	
    	$sku = DB::table('sku as v')
				->select('v.*')
				->where('id',$id)
				->first();
				// ->get();
		
		return $sku;
    }
	
}
