<?php

namespace App\Models;

// use App\Models\ProjectUser;
use Illuminate\Database\Eloquent\Model;
use DB;

class Purchase_order extends Model
{
    
	protected $table = 'purchase_order';
    protected $fillable = [ 'id', 'user_id', 'eta', 'order_date', 'created_at', 'po_nbr' ];
	
	public static function get_purchase_orders( )
    {
		$purchase_orders = DB::table('purchase_order as v')
				->select('v.*')
				->orderBy('po_nbr', 'asc')
				->get();
		
		return $purchase_orders;
    }

	
	public static function add_purchase_order( $data )
    {
		
		$data['user_id'] = auth()->id();
		unset ( $data['order_ids'] );
		$purchase_orders = DB::table('purchase_order')
				// ->insert(
				->insertGetId(
					$data
				);

		return $purchase_orders;
    }
	
	public static function add_so_to_purchase_order( $PO_ID , $SO )
    {
		$data = array();
		$data['purchase_order_id'] = $PO_ID;
		$data['special_order_id'] = $SO ;
		
		$purchase_orders = DB::table('purchase_order_special_order')
				->where('special_order_id', $SO)
				->delete();
				
		$purchase_orders = DB::table('purchase_order_special_order')
				->insert(
					$data
				);

		return true;
    }
	
	public static function get_so_of_purchase_order( $PO_ID  )
    {
		$purchase_orders = DB::table('purchase_order_special_order as poso')
				->leftJoin('special_order as so', 'poso.special_order_id', '=', 'so.id')
				->leftJoin('users as u', 'so.salesperson_id', '=', 'u.id')
				->leftJoin('store as s', 'u.store_id', '=', 's.id')
				->leftJoin('vendor as v', 'so.vendor_id', '=', 'v.id')
				->where('poso.purchase_order_id', '=', $PO_ID)
				->select('so.*' , 's.store_nbr' , 'v.name as vendor_name' )
				->get();

		return $purchase_orders;
    }
	
	public static function cancel_order( $SO )
    {
		$purchase_orders = DB::table('purchase_order_special_order')
				->where('special_order_id', $SO)
				->delete();

		return true;
    }
	
	public static function edit_purchase_order( $data )
    {
		$purchase_orders = DB::table('purchase_order')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_purchase_order( $id )
    {
		$data['active'] = 0;
		$purchase_orders = DB::table('purchase_order')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_purchase_order( $id )
    {
		$data['active'] = 1;
		$purchase_orders = DB::table('purchase_order')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_purchase_order_by_id( $id )
    {	
    	$purchase_order = DB::table('purchase_order as v')
				->select('v.*')
				->where('id',$id)
				->first();
				// ->get();
		
		return $purchase_order;
    }
	
}
