<?php

namespace App\Models;

// use App\Models\ProjectUser;
use Illuminate\Database\Eloquent\Model;
use DB;

class Message extends Model
{
    
	protected $table = 'message';
    protected $fillable = [ 'id', 'message', 'create_date' ];
	
	public static function get_messages( )
    {
		$messages = DB::table('message as v')
				->select('v.*')
				->get();
		
		return $messages;
    }
	
	public static function get_messages_enabled( )
    {
		$messages = DB::table('message as m')
				->select('m.*' , 'users.name')
				->where('active', 1 )
				->leftJoin('users', 'users.id', '=', 'm.user_id')
				->orderBy('create_date', 'desc')
				->limit(20)
				->get();
		
		return $messages;
    }

	
	public static function add_message( $data )
    {
		// $data['user_id'] = auth()->id();
		
		$messages = DB::table('message')
				->insert(
					$data
				);
		// $message = self::create($data);

		return true;
    }
	
	public static function edit_message( $data )
    {
		$messages = DB::table('message')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_message( $id )
    {
		$data['active'] = 0;
		$messages = DB::table('message')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_message( $id )
    {
		$data['active'] = 1;
		$messages = DB::table('message')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_message_by_id( $id )
    {	
    	$message = DB::table('message as v')
				->select('v.*')
				->where('id',$id)
				->first();
				// ->get();
		
		return $message;
    }
	
}
