<?php

namespace App\Models;

// use App\Models\ProjectUser;
use Illuminate\Database\Eloquent\Model;
use DB;

class Count extends Model
{
    
	protected $table = 'count';
    protected $fillable = [ 'id', 'name' ];
	
	public static function get_counts( $count_id = null )
    {
		$counts = DB::table('count as c')
				->select('c.*','store.store_nbr','sku.name','users.name as user_name')
				->leftJoin('store', 'store.id', '=', 'c.store_id')
				->leftJoin('sku', 'sku.id', '=', 'c.sku_id')
				->leftJoin('users', 'users.id', '=', 'c.user_id');
				
		if ( auth()->user()->type != "admin" )
			$counts->where('users.id', auth()->id() );
		
		if ( $count_id != null )
			$counts->where('c.id', $count_id );
		
		$counts	 = $counts->get();
		
		return $counts;
    }
	
	public static function get_counts_total( $count_id = null , $from = null , $to = null )
    {
		$counts = DB::table('count as c')
				->select('c.*','store.store_nbr','sku.name','users.name as user_name',DB::raw('sum(c.value) as total '))
				->leftJoin('store', 'store.id', '=', 'c.store_id')
				->leftJoin('sku', 'sku.id', '=', 'c.sku_id')
				->leftJoin('users', 'users.id', '=', 'c.user_id')
				->groupBy('store_nbr','sku.name');
				
		if ( auth()->user()->type != "admin" )
			$counts->where('users.id', auth()->id() );
		
		if ( $count_id != null )
			$counts->where('c.id', $count_id );
		
		
		if ( $from != null && $to != null )
		{
			// $counts->whereDate('c.date', '<='  , "'".$to."'" );
			// $counts->whereDate('c.date', '>=' , "'".$from."'" );
			// $from = date($from);
			// $to = date($to);
			// $counts->whereBetween(DB::raw('date(c.date)'), [ "'".$from."'" , "'".$to."'" ] );
			$counts->whereRaw("date(c.date) between date('".$from."') and date('".$to."')" );
		}
		$counts	 = $counts->get();
		
		// print_r($counts);die();
		return $counts;
    }
	
	public static function get_counts_count_by_name( $name )
    {
		$counter = DB::table('count as s')
				->select(  DB::raw('count(*) as counter '))
				->where('name',$name)
				->first();
				
		return $counter->counter ;
				
		
    }

	
	public static function add_count( $data )
    {
		// $data['user_id'] = auth()->id();
		
		$counts = DB::table('count')
				->insert(
					$data
				);
		// $count = self::create($data);

		return true;
    }
	
	public static function edit_count( $data )
    {
		$counts = DB::table('count')
				->where('id',$data["id"])
				->update(
					$data
				);

		return true;
    }
	
	public static function edit_count_by_name( $data )
    {
		$counts = DB::table('count')
				->where('name', 'like' , (string) $data["name"])
				->update(
					$data
				);

		return true;
    }
	
	
	public static function disable_count( $id )
    {
		$data['active'] = 0;
		$counts = DB::table('count')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	public static function enable_count( $id )
    {
		$data['active'] = 1;
		$counts = DB::table('count')
				->where('id',$id )
				->update( $data );

		return true;
    }
	
	
    public static function get_count_by_id( $id )
    {	
    	$count = DB::table('count as v')
				->select('v.*')
				->where('id',$id)
				->first();
				// ->get();
		
		return $count;
    }
	
}
