<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\ProjectUser;

class ProjectAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        $has_admin_rights = ProjectUser::getCurrentUserProjectsWithAdminRights();
        if(!auth()->check()){
            return redirect("/");
        } else {
            if(auth()->user()->type != 'admin' && empty($has_admin_rights)){
                return redirect("/");
            }
        }
        
        return $next($request);
    }
}
