<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\VendorAddEditRequest;
use View;
use Mail;
use App\Models\Vendor as Vendors_model;

use Illuminate\Support\Facades\Auth;

// use Request;

class VendorsController extends Controller
{

	public function __construct(Vendors_model $vendor, Request $request)
	{
		$this->vendor = $vendor;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$vendors = $this->vendor->get_vendors();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Vendors" , "vendors"=> $vendors );
        return view('vendors', $data);
		
    }
	
	public function getVendor_add()
    {
		
		$vendors = $this->vendor->get_vendors();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Vendor Add" , "vendors"=> $vendors );
        return view('vendor_add', $data);
		
    }
	
	public function postVendor_add(VendorAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Vendors_model::add_vendor($data);
		return redirect()->to('vendor');
		
    }
	
	public function getVendor_edit( $id)
    {
		
		$vendor = $this->vendor->get_vendor_by_id($id);
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Vendor Edit" , "vendor"=> $vendor );
        return view('vendor_edit', $data);
		
    }
	
	public function getVendor_disable($id)
    {
		Vendors_model::disable_vendor($id);
		return redirect()->to('vendor');
		
    }
	
	public function getVendor_enable( $id)
    {
		Vendors_model::enable_vendor($id);
		return redirect()->to('vendor');
		
    }
	
	public function postVendor_edit(VendorAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Vendors_model::edit_vendor($data);
		return redirect()->to('vendor');
		
    }

}
