<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\UserAddEditRequest;
use View;
use Mail;
use App\User as Users_model;
use App\Models\Store as Stores_model;

use Illuminate\Support\Facades\Auth;

// use Request;

class UsersController extends Controller
{

	public function __construct(Users_model $user,Stores_model $store, Request $request)
	{
		$this->user = $user;
		$this->store = $store;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$users = $this->user->get_users();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Users" , "users"=> $users );
        return view('users', $data);
		
    }
	
	public function getUser_add()
    {
		
		$users = $this->user->get_users();
		$stores = $this->store->get_stores();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "User Add" , "users"=> $users  , "stores"=> $stores);
        return view('user_add', $data);
		
    }
	
	public function postUser_add(UserAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Users_model::add_user($data);
		return redirect()->to('user');
		
    }
	
	public function getUser_edit( $id)
    {
		
		$user = $this->user->get_user_by_id($id);
		$stores = $this->store->get_stores();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "User Edit" , "user"=> $user , "stores"=> $stores);
        return view('user_edit', $data);
		
    }
	
	public function getUser_disable($id)
    {
		Users_model::disable_user($id);
		return redirect()->to('user');
		
    }
	
	public function getUser_enable( $id)
    {
		Users_model::enable_user($id);
		return redirect()->to('user');
		
    }
	
	public function postUser_edit(UserAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Users_model::edit_user($data);
		return redirect()->to('user');
		
    }

}
