<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\StoreAddEditRequest;
use View;
use Mail;
use App\Models\Store as Stores_model;

use Illuminate\Support\Facades\Auth;

// use Request;

class StoresController extends Controller
{

	public function __construct(Stores_model $store, Request $request)
	{
		$this->store = $store;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$stores = $this->store->get_stores();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Stores" , "stores"=> $stores );
        return view('stores', $data);
		
    }
	
	public function getStore_add()
    {
		
		$stores = $this->store->get_stores();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Store Add" , "stores"=> $stores );
        return view('store_add', $data);
		
    }
	
	public function postStore_add(StoreAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Stores_model::add_store($data);
		return redirect()->to('store');
		
    }
	
	public function getStore_edit( $id)
    {
		
		$store = $this->store->get_store_by_id($id);
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Store Edit" , "store"=> $store );
        return view('store_edit', $data);
		
    }
	
	public function getStore_disable($id)
    {
		Stores_model::disable_store($id);
		return redirect()->to('store');
		
    }
	
	public function getStore_enable( $id)
    {
		Stores_model::enable_store($id);
		return redirect()->to('store');
		
    }
	
	public function postStore_edit(StoreAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Stores_model::edit_store($data);
		return redirect()->to('store');
		
    }

}
