<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\Special_orderAddEditRequest;
use View;
use Mail;
use App\Models\Special_order as Special_orders_model;
use App\Models\Purchase_order as Purchase_orders_model;
use App\Models\File as File_model;
use App\Models\Vendor as Vendors_model;

use Illuminate\Support\Facades\Auth;

// use Request;

class Special_ordersController extends Controller
{

	public function __construct(Purchase_orders_model $purchase_order, Special_orders_model $special_order, Vendors_model $vendor, Request $request)
	{
		$this->purchase_order = $purchase_order;
		$this->special_order = $special_order;
		$this->vendor = $vendor;
		$this->request = $request;
	}

	public function getIndex( $order_status = "" )
    {
		$created_SO_count = $this->special_order->get_created_SO_count();
		$ordered_SO_count = $this->special_order->get_ordered_SO_count();
		$canceled_SO_count = $this->special_order->get_canceled_SO_count();
		$purchase_orders = $this->purchase_order->get_purchase_orders();
		
		$special_orders = $this->special_order->get_special_orders( false , $order_status );
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Special_orders" , "special_orders"=> $special_orders, "created_SO_count"=> $created_SO_count , "ordered_SO_count"=> $ordered_SO_count , "canceled_SO_count"=> $canceled_SO_count , "purchase_orders"=> $purchase_orders  );
        return view('special_orders', $data);
		
    }
	
	public function getSpecial_order_add()
    {
		
		$special_orders = $this->special_order->get_special_orders();
		$vendors = $this->vendor->get_vendors();
		$stores = \DB::select( \DB::raw( " SELECT store.store_nbr , users.id FROM `store` LEFT JOIN users ON users.store_id = store.id where type like 'employee' group by store.store_nbr, users.id  ") );
		
		// print_r($stores); die("*****");
		$data = array( "layout"=> $this->default_layout , "title"=> "Special_order Add" , "special_orders"=> $special_orders , "vendors"=> $vendors  , "stores"=> $stores );
        return view('special_order_add', $data);
		
    }
	
	public function postSpecial_order_add(Special_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		
		$file_ids = array();
		$file_ids_counter = 0;
		$files_multi = $request->allFiles('files');
		if($request->hasFile('files'))
		{
			foreach ($files_multi as $files) {
				foreach ($files as $file) {
					// print_r($file);
						echo 'File Name: '.$file->getClientOriginalName();
					//Move Uploaded File
						$destinationPath = 'uploads';
						$file_name = time() . "_" . $file->getClientOriginalName();
						$file->move($destinationPath, $file_name );
						
						$file_data = array();
						$file_data['original_name'] = $file->getClientOriginalName() ;
						$file_data['name'] = $file_name ;
						$file_data['ext'] = $file->getClientOriginalExtension() ;
						
						$file_ids[$file_ids_counter ++ ] = File_model::add_file($file_data);
				}
			}
		}
		
		
		
		$articles = $data['articles'];
		$files = $data['files'];
		unset ( $data['articles'] );
		unset ( $data['files'] );
		foreach ($articles as &$article) {
			$data["sku"] = $article['sku'] ;
			$data["cat"] = $article['cat'] ;
			$data["qty"] = $article['qty'] ;
			$data["description"] = $article['description'] ;
			$data["net_price"] = $article['net_price'] ;
			$data["quoted_price"] = $article['quoted_price'] ;
			$data["pre_payment"] = $article['pre_payment'] ;
			
			$special_order_id = Special_orders_model::add_special_order($data);
			
			foreach ($file_ids as &$file_id) {
				File_model::add_file_to_so($file_id , $special_order_id );
			}
		}
		
		return redirect()->to('special_order');
		
    }
	
	public function getSpecial_order_edit( $id)
    {
		
		$special_order = $this->special_order->get_special_order_by_id($id);
		$special_order_files = File_model::get_file_by_sp_id($id);
		$vendors = $this->vendor->get_vendors();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Special_order Edit" , "special_order"=> $special_order , "vendors"=> $vendors , "special_order_files"=> $special_order_files );
        return view('special_order_edit', $data);
		
    }
	
	public function getSpecial_order_disable($id)
    {
		Special_orders_model::disable_special_order($id);
		return redirect()->to('special_order');
		
    }
	
	public function getSpecial_order_enable( $id)
    {
		Special_orders_model::enable_special_order($id);
		return redirect()->to('special_order');
		
    }
	
	public function postSpecial_order_edit(Special_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		if ( isset( $data["call1"] ) && $data["call1"] == 1 )
		{
			$data["call1"] = \DB::raw( " now() " );
		}
		// print_r($data);
		// die("***");
		Special_orders_model::edit_special_order($data);
		return redirect()->to('special_order');
		
    }
	
	public function getPrint_so( $id )
    {
		$special_order = $this->special_order->get_special_order_by_id( $id );
		$vendors = $this->vendor->get_vendors();
		$data = array( "layout"=> $this->default_layout , "title"=> "Login", "special_order"=> $special_order, "vendors"=> $vendors   );
		
		// return view('special_order_edit', $data);
		// return view('print_so', $data);
		
		return \PDF::loadView("print_so", $data)
			->setPaper('A4')
			->setOption('page-size', 'A4')
			// ->setOrientation('landscape')
			->download("print_so".".pdf");
			
       
		
    }
	
	public function postReceive_orders(Special_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		
		foreach ( $data['order_ids'] as &$SO) {
			
			$special_order_data = array();
			$special_order_data['id'] = $SO;
			$special_order_data['status'] = "received";
			$special_order_data['status_date'] = \DB::raw( " now() " );
			$special_order_data['received_date'] = $special_order_data['status_date'];
			Special_orders_model::edit_special_order( $special_order_data );
		}
		
		return response()->json([
			'success' => true,
		]);
		
    }

}
