<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\SkuAddEditRequest;
use View;
use Mail;
use App\Models\Sku as Skus_model;

use App\Imports\SkuImport as SkuImport_model;
use Illuminate\Support\Facades\Auth;

// use Request;

class SkusController extends Controller
{

	public function __construct(Skus_model $sku, Request $request)
	{
		$this->sku = $sku;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$skus = $this->sku->get_skus();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Skus" , "skus"=> $skus );
        return view('skus', $data);
		
    }
	
	public function getSku_upload()
    {
		
		$skus = $this->sku->get_skus();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Sku Add" , "skus"=> $skus );
        return view('sku_upload', $data);
		
    }
	
	public function postSku_upload(request $request)
    {
		
		// $data = $request->all();
		
		ini_set('max_execution_time', '900');
		
		$file_name = time().".".$request->file->getClientOriginalExtension();
		
		
		
		
		$tmp_name = $request->file->store('skus_file' )  ; 
		 
		 
		$rows = \Excel::toArray(new SkuImport_model, storage_path()."/app/".$tmp_name);
		
		
		// print_r($rows[0]);
		// die("****");
		foreach ( $rows[0] as &$sku) {
			if ( $sku[0] == "Item" && $sku[1] == "Desc" )
				continue;
			$data["name"] = $sku[0];
			$data["description"] = $sku[1];
			// print_r($data);die();
			if ( Skus_model::get_skus_count_by_name( $data["name"] ) == 0 )
			{
				Skus_model::add_sku($data);
			}
			else
			{
				
				Skus_model::edit_sku_by_name($data);
			}
			
		}
		
		return redirect()->to(url('/sku'));
		
    }
	
	public function postSku_check(request $request)
    {
		
		$data = $request->all();
		
		if ( Skus_model::get_skus_count_by_name( $data["name"] ) != 0 )
		{
			$sku = Skus_model::get_sku_by_name( $data["name"] );
			return response()->json(['success' => true, 'description' => $sku->description, 'id' => $sku->id ]);
		}
		else
		{
			return response()->json(['success' => false ]);
		}
		
    }
	
	public function getSku_add()
    {
		
		$skus = $this->sku->get_skus();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Sku Add" , "skus"=> $skus );
        return view('sku_add', $data);
		
    }
	
	public function postSku_add(SkuAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Skus_model::add_sku($data);
		return redirect()->to('sku');
		
    }
	
	public function getSku_edit( $id)
    {
		
		$sku = $this->sku->get_sku_by_id($id);
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Sku Edit" , "sku"=> $sku );
        return view('sku_edit', $data);
		
    }
	
	public function getSku_disable($id)
    {
		Skus_model::disable_sku($id);
		return redirect()->to('sku');
		
    }
	
	public function getSku_enable( $id)
    {
		Skus_model::enable_sku($id);
		return redirect()->to('sku');
		
    }
	
	public function postSku_edit(request $request)
    {
		
		$data = $request->all();
		
		Skus_model::edit_sku($data);
		return redirect()->to('sku');
		
    }

}
