<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\Purchase_orderAddEditRequest;
use View;
use Mail;
use App\Models\Purchase_order as Purchase_orders_model;
use App\Models\Special_order as Special_orders_model;

use Illuminate\Support\Facades\Auth;

// use Request;

class Purchase_ordersController extends Controller
{

	public function __construct(Purchase_orders_model $purchase_order, Special_orders_model $special_order, Request $request)
	{
		$this->purchase_order = $purchase_order;
		$this->special_order = $special_order;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$purchase_orders = $this->purchase_order->get_purchase_orders();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Purchase_orders" , "purchase_orders"=> $purchase_orders );
        return view('purchase_orders', $data);
		
    }
	
	public function getPurchase_order_add()
    {
		
		$purchase_orders = $this->purchase_order->get_purchase_orders();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Purchase_order Add" , "purchase_orders"=> $purchase_orders );
        return view('purchase_order_add', $data);
		
    }
	
	public function postPurchase_order_add(Purchase_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Purchase_orders_model::add_purchase_order($data);
		return redirect()->to('purchase_order');
		
    }
	
	public function postAdd_orders_to_purchase_order(Purchase_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		
		if ( isset( $data['purchasing_order_id'] ) )
		{
			$PO_ID = $data['purchasing_order_id'];
		}
		else
		{
			$PO_ID = Purchase_orders_model::add_purchase_order($data);
		}
		
		// die("***********".$PO_ID);
		foreach ( $data['order_ids'] as &$SO) {
			Purchase_orders_model::add_so_to_purchase_order( $PO_ID , $SO );
			
			$special_order_data = array();
			$special_order_data['id'] = $SO;
			$special_order_data['status'] = "ordered";
			$special_order_data['status_date'] = \DB::raw( " now() " );
			$special_order_data['ordered_date'] = $special_order_data['status_date'];
			Special_orders_model::edit_special_order( $special_order_data );
		}
		
		return response()->json([
			'success' => true,
		]);
		// return redirect()->to('purchase_order');
		
    }
	
	
	public function postCancel_orders(Purchase_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		
		// die("***********".$PO_ID);
		foreach ( $data['order_ids'] as &$SO) {
			Purchase_orders_model::cancel_order( $SO );
			
			$special_order_data = array();
			$special_order_data['id'] = $SO;
			$special_order_data['status'] = "canceled";
			$special_order_data['status_date'] = \DB::raw( " now() " );
			$special_order_data['cancel_date'] = $special_order_data['status_date'];
			Special_orders_model::edit_special_order( $special_order_data );
		}
		
		return response()->json([
			'success' => true,
		]);
		// return redirect()->to('purchase_order');
		
    }
	
	public function getCancel_order( $id , $po_id = false )
    {
		
		Purchase_orders_model::cancel_order( $id  );
			
			$special_order_data = array();
			$special_order_data['id'] = $id;
			$special_order_data['status'] = "canceled";
			$special_order_data['status_date'] = \DB::raw( " now() " );
			$special_order_data['cancel_date'] = $special_order_data['status_date'];
			Special_orders_model::edit_special_order( $special_order_data );
		if ( $po_id == false )
			return redirect()->to('/home');
		else
			return redirect()->to('/purchase_order_edit/'.$po_id);
		
    }
	
	public function getPurchase_order_edit( $id)
    {
		
		$purchase_order = $this->purchase_order->get_purchase_order_by_id($id);
		$special_orders = $this->purchase_order->get_so_of_purchase_order($id);
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Purchase_order Edit" , "purchase_order"=> $purchase_order, "special_orders"=> $special_orders );
        return view('purchase_order_edit', $data);
		
    }
	
	public function getPurchase_order_disable($id)
    {
		Purchase_orders_model::disable_purchase_order($id);
		return redirect()->to('purchase_order');
		
    }
	
	public function getPurchase_order_enable( $id)
    {
		Purchase_orders_model::enable_purchase_order($id);
		return redirect()->to('purchase_order');
		
    }
	
	public function postPurchase_order_edit(Purchase_orderAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Purchase_orders_model::edit_purchase_order($data);
		return redirect()->to('purchase_order');
		
    }

}
