<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
// use Request;

// use App\Http\Requests;

use App\Http\Requests\ProjectAddEditRequest;
use View;
use Mail;
use App\Models\Project as Projects_model;
use App\User as Users_model;
use App\Models\Song;	
use App\Models\ProjectSong;
use App\Models\ProjectUser;

use Illuminate\Support\Facades\Auth;

// use Request;

class ProjectsController extends Controller
{

	public function __construct(Projects_model $project, Request $request)
	{
		$this->project = $project;
		$this->request = $request;
	}

	public function getIndex(ProjectUser $project_user, Users_model $user )
    {
		// if(auth()->user()->type != 'admin'){
			// $project_as_admin_ids = $project_user->getCurrentUserProjectsWithAdminRights();
			// $projects = $this->project->get_projects_by_ids($project_as_admin_ids);
		// }else{
			$projects = $this->project->get_projects();
		// }
		$clients = $this->project->get_clients();
		$users = $user->get_active_users();
		foreach ($projects as &$project) {
			$project->assigned_users = $project_user->get_assigned_users( $project->id );
		}
		// $assigned = projects_model::get_assigned_users();
		$data = array( "title"=> "Projects list" , "contents"=> "projects" , "projects"=> $projects , "clients"=> $clients, "users"=> $users   );
		return view('test', $data);
    }


    public function getMyProjects(ProjectUser $project_user, Users_model $user)
    {
		$clients = $this->project->get_clients();
    	$projects = $this->project->get_current_user_projects();
    	$users = $user->get_active_users();
    	foreach ($projects as &$project) {
    		if(intval($project->admin) == 1){
    			$project->assigned_users = $project_user->get_assigned_users( $project->id );
    		}
    	}
    	return view('projects.my_projects', ['projects' => $projects, 'clients' => $clients, "users"=> $users ] );
    }

    public function getEditUserAssignedProject($id, Song $song_model, ProjectSong $project_song_model, ProjectUser $project_user)
    {
    	$user_permissions = $project_user->get_user_permission_for_project($id, auth()->id());
    	if(isset($user_permissions) && (intval($user_permissions->admin) || intval($user_permissions->edit) || intval($user_permissions->view)) ){
    		$project = $this->project->get_current_user_assigned_project($id);
    		$is_edit = intval($user_permissions->edit);
    		$is_view = intval($user_permissions->view);
    		if($project){
    			$user_songs = NULL;
    			if($is_edit){
    				$user_songs = $song_model->get_user_non_assigned_to_project_songs($id, auth()->id());
    				$cur_user_not_published_songs = $song_model->get_user_not_liked_songs_assigned_to_project( $id , auth()->id() );
    			}
    			$songs = $song_model->get_all_and_project_songs_grouped($id);
    			if(isset($cur_user_not_published_songs) && isset($songs) && !empty($cur_user_not_published_songs))
    			{
    				$songs = array_merge($cur_user_not_published_songs, $songs);
    			}
    			$activity_of_users = NULL;
    			if($is_view){
    				$activity_of_users = $song_model->get_activity_of_users_for_project($id);
    				if(isset($songs) && !empty($songs) && isset($activity_of_users) && !empty($activity_of_users))
    				foreach ($songs as $key => $song) {
    					foreach ($activity_of_users as $a_key => $activity) {
    						if($activity->song_id == $song->id){
    							$song->activity[$a_key] = $activity;
    						}
    					}
    				}
    			}

    			return view ('projects.edit' , ['project' => $project, 'songs' => $songs, 'user_songs' => $user_songs, 'is_edit' => $is_edit, 'is_view' => $is_view] );
    		}

    	}
    	return redirect()->to('my-projects');

    }

    public function getShowUserAssignedProject( $id, Song $song_model, ProjectUser $project_user ){

    	$user_permissions = $project_user->get_user_permission_for_project($id, auth()->id());
    	if(isset($user_permissions) && ($user_permissions->admin || $user_permissions->view) ){
	    	$project = $this->project->get_current_user_assigned_project($id);
	    	if($project){
	    		$songs = $song_model->get_all_assigned_songs_of_project( $id ); // this can return same song more then once.
	    		return view ('projects.show' , ['project' => $project, 'songs' => $songs ] );
	    	}
	    }
    	return redirect()->to('my-projects');
    }
	
	public function postEdit_project(ProjectAddEditRequest $request)
    {
		
		$data = $request->all();
		if ($request->hasFile('file'))
		{
		   // $request->file('user_photo')->store('avatars')
		   $file_name = time().".".$this->request->file('file')->getClientOriginalExtension() ;
		   $request->file('file')->move(public_path('uploads'), $file_name);
		   $data["video_url"] = asset( "uploads/".$file_name);
		}
		
		
		projects_model::edit_project($data);
		return response()->json([ 'status' => 200, 'success' => true, 'message' => 'Project successfully updated.' ]);

		
    }
	
	public function postAdd_project(ProjectAddEditRequest $request)
    {
		
		$data = $request->all();
		if ($request->hasFile('file'))
		{
		   // $request->file('user_photo')->store('avatars')
		   $file_name = time().".".$this->request->file('file')->getClientOriginalExtension() ;
		   $request->file('file')->move(public_path('uploads'), $file_name);
		   $data["video_url"] = asset( "uploads/".$file_name);
		}
		
		
		projects_model::add_project($data);
		return response()->json([ 'status' => 200, 'success' => true, 'message' => 'Project successfully created.' ]);
		
    }
	
	public function postActivate_project(ProjectUser $project_user)
    {
    	if($project_user->userHasAdminPermission($this->request->get('id'), auth()->id()) || auth()->user()->type == 'admin'){
 			projects_model::activate_project($this->request->all());
 			return response()->json(['status' => 200, 'success' => true, 'message' => 'Project has been successfully activated.']);
		}
    	return response()->json(['status'=>101, 'success' => false, 'message' => 'You have not right permissions to do this.']);

    }
	
	public function postDisactivate_project(ProjectUser $project_user)
    {
		
    	if($project_user->userHasAdminPermission($this->request->get('id'), auth()->id()) || auth()->user()->type == 'admin'){
			projects_model::disactivate_project($this->request->all());
 			return response()->json(['status' => 200, 'success' => true, 'message' => 'Project has been successfully deactivated.']);

 		}
    	return response()->json(['status'=>101, 'success' => false, 'message' => 'You have not right permissions to do this.']);
				
    }
	
	public function postAssign_user_project(Users_model $userModel, ProjectUser $project_user)
    {
    	if($project_user->userHasAdminPermission($this->request->get('project_id'), auth()->id()) || auth()->user()->type == 'admin')
    	{

	    	$data = $this->request->all();
			$request = $project_user->add_assigned_user($data);
			if($request){
				$project = $this->project->getProjectNameById($data['project_id']);
				$data['project_name'] = $project->project;
				$data['user'] = $userModel->getUserById($data['user_id']);
				$data['site_url'] 	= config('app.url');
				$data['site_email'] = config('mail.from.address');
				$data['site_name'] 	= config('mail.from.name');
				// dd($data);
				// dd($data);
				$data['subject'] = "You where assigned to ". $data['project_name'] ." project";
				// $mail = Mail::send('emails.user_assign_to_project', $data, function($message) use ($data)
				// {
				//     $message->from($data['site_email'], $data['site_name']);
				//     $message->subject($data['subject']);
				//     $message->to($data['user']->email);
				// });
			}
			return response()->json([ 'status' => 200, 'success' => true, 'message' => $data['user']->firstname.' '. $data['user']->lastname .' has been successfully assigned to the '.$data['project_name'].' project.' ]);
		}
    	return response()->json(['status'=>101, 'success' => false, 'message' => 'You have not right permissions to do this.']);

    }
	
	
	public function postUnassign_user_project(Users_model $userModel, ProjectUser $project_user)
    {
    	if($project_user->userHasAdminPermission($this->request->get('project_id'), auth()->id()) || auth()->user()->type == 'admin')
    	{
	    	$data = [];
			$project = $this->project->getProjectNameById($this->request->get('project_id'));
			$data['project_name'] = $project->project;
			$data['user'] = $userModel->getUserById($this->request->get('user_id'));

			$project_user->remove_assigned_user($this->request->all());
			return response()->json([ 'status' => 200, 'success' => true, 'message' => $data['user']->firstname.' '. $data['user']->lastname .' has been successfully removed from '.$data['project_name'].' project.' ]);
    		
    	}
    	return response()->json(['status'=>101, 'success' => false, 'message' => 'You have not right permissions to do this.']);
		
    }


    public function postSongAdd(ProjectSong $project_song)
    {
    	return $project_song->createAssignSongToProject( $this->request->all() );
    }
	
	public function postSongEdit(ProjectSong $project_song)
    {
    	return $project_song->editAssignSongToProject( $this->request->all() );
    }	

	public function postSongRemove(ProjectSong $project_song)
	{
    	return $project_song->removeSongFromProject( $this->request->all() );
	}
}
