<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\MessageAddEditRequest;
use View;
use Mail;
use App\Models\Message as Messages_model;

use Illuminate\Support\Facades\Auth;

// use Request;

class MessagesController extends Controller
{

	public function __construct(Messages_model $message, Request $request)
	{
		$this->message = $message;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$messages = $this->message->get_messages();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Messages" , "messages"=> $messages );
        return view('messages', $data);
		
    }
	
	public function getMessage_add()
    {
		
		$messages = $this->message->get_messages();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Message Add" , "messages"=> $messages );
        return view('message_add', $data);
		
    }
	
	public function postMessage_add(MessageAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Messages_model::add_message($data);
		return redirect()->to('message');
		
    }
	
	public function getMessage_edit( $id)
    {
		
		$message = $this->message->get_message_by_id($id);
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Message Edit" , "message"=> $message );
        return view('message_edit', $data);
		
    }
	
	public function getMessage_disable($id)
    {
		Messages_model::disable_message($id);
		return redirect()->to('message');
		
    }
	
	public function getMessage_enable( $id)
    {
		Messages_model::enable_message($id);
		return redirect()->to('message');
		
    }
	
	public function postMessage_edit(MessageAddEditRequest $request)
    {
		
		$data = $request->all();
		
		Messages_model::edit_message($data);
		return redirect()->to('message');
		
    }

}
