<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\Special_orderAddEditRequest;
use App\Models\Special_order as Special_orders_model;
use App\Models\Purchase_order as Purchase_orders_model;
use App\Imports\SkuImport as SkuImport_model;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(Purchase_orders_model $purchase_order,Special_orders_model $special_order,SkuImport_model $SkuImport, Request $request)
    {
        $this->SkuImport = $SkuImport;
        $this->purchase_order = $purchase_order;
        $this->special_order = $special_order;
		$this->request = $request;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
		
		// $rows = \Excel::toArray(new SkuImport_model, public_path()."/uploads/".'Inventory Item and Cost List.xlsx');
		
		// print_r($rows);
		// die("****");
		// $created_SO_count = $this->special_order->get_created_SO_count();
		// $ordered_SO_count = $this->special_order->get_ordered_SO_count();
		// $canceled_SO_count = $this->special_order->get_canceled_SO_count();
		// $received_SO_count = $this->special_order->get_received_SO_count();
		
		// $special_orders = $this->special_order->get_special_orders( false );
		// $purchase_orders = $this->purchase_order->get_purchase_orders();
		
		// print_r($special_orders); die();
		// print_r( $canceled_SO_count->toJson(JSON_PRETTY_PRINT) ); die("*****");
		
			$view = "home";
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Home"   );
        return view( $view , $data);
    }
	
	public function getPrint_home(  )
    {
		
		$created_SO_count = $this->special_order->get_created_SO_count();
		$ordered_SO_count = $this->special_order->get_ordered_SO_count();
		$canceled_SO_count = $this->special_order->get_canceled_SO_count();
		$special_orders = $this->special_order->get_special_orders( false );
		$purchase_orders = $this->purchase_order->get_purchase_orders();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Home" , "created_SO_count"=> $created_SO_count , "ordered_SO_count"=> $ordered_SO_count , "canceled_SO_count"=> $canceled_SO_count , "special_orders"=> $special_orders , "purchase_orders"=> $purchase_orders  );
		
		return \PDF::loadView("home_purchasing", $data)
			->setPaper('A4')
			->setOption('page-size', 'A4')
			->setOrientation('landscape')
			->download("home_purchasing".".pdf");
		
    }
}
