<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests\CountAddEditRequest;
use View;
use Mail;
use App\Models\Count as Counts_model;
use App\User as Users_model;
use Illuminate\Support\Facades\Auth;

use App\Imports\CountExport as CountExport_model;

// use Request;

class CountsController extends Controller
{

	public function __construct(Counts_model $count, Request $request)
	{
		$this->count = $count;
		$this->request = $request;
	}

	public function getIndex()
    {
		
		$counts = $this->count->get_counts();
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Counts" , "counts"=> $counts );
        return view('counts', $data);
		
    }
	
	public function getCount_download()
    {
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Counts" );
        return view('count_download', $data);
		
    }
	
	public function postCount_download(request $request)
    {
		
		$data = $request->all();
		$count_array[] = array('Export date: ' . date('m/d/Y h:i:s a', time()) );
		
		array_push($count_array, array() );
		array_push($count_array, array('Store', 'SKU', 'Count') );
		$counts = $this->count->get_counts_total( null , $data['from'] ,  $data['to']);
		
		foreach($counts as $count)
		{
			array_push($count_array, array( $count->store_nbr, $count->name,$count->total ) );
		}
		
		$export =  new CountExport_model([
			$count_array
		]);
		return \Excel::download($export , 'count.xlsx');
		
		die();
		
		
    }
	
	public function getCount_add()
    {
		
		$store = Users_model::get_user_store();
		$data = array( "layout"=> $this->default_layout , "title"=> "Count Add" , "store_name"=> $store->store_nbr . " : " . $store->description , "store_id"=> $store->id );
        return view('count_add', $data);
		
    }
	
	public function postCount_add(request $request)
    {
		$data = $request->all();
		$data['user_id'] = auth()->id();
		Counts_model::add_count($data);
		
		return redirect()->to( url('/count/add'));
		
    }
	
	public function getCount_edit( $id)
    {
		
		$count = $this->count->get_counts($id);
		
		$data = array( "layout"=> $this->default_layout , "title"=> "Count Edit" , "count"=> $count[0] );
        return view('count_edit', $data);
		
    }
	
	public function postCount_edit(request $request)
    {
		
		$data = $request->all();
		// print_r($data);die();
		Counts_model::edit_count($data);
		return redirect()->to('/count');
		
    }
	
	public function getCount_disable($id)
    {
		Counts_model::disable_count($id);
		return redirect()->to('count');
		
    }
	
	public function getCount_enable( $id)
    {
		Counts_model::enable_count($id);
		return redirect()->to('count');
		
    }
	
	

}
