<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use Auth;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers {
		logout as performLogout;
	}

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

	public function showLoginForm()
	{
		$data = array( "layout"=> $this->default_layout , "title"=> "Login"   );
        return view('login', $data);
	}

	public function logout(Request $request)
	{
		$this->performLogout($request);
		return redirect()->route('home');
    }

    public function postLogin(Request $request)
    { 

		// $user = new \App\User();
		// $user->password = \Hash::make('9876543210');
		// $user->email = 'admin@gmail.com';
		// $user->approved = 1;
		// $user->type = 'admin';
		// $user->name = 'badr admin';
		// $user->save();
        $this->validate($request, [
            'email' => 'required|email', 'password' => 'required',
        ]);
        $request['approved'] = 1;
        $credentials = $request->only('email', 'password');
        // This section is the only change
        if (Auth::validate($credentials)) {
            $user = Auth::getLastAttempted();
            if ($user->approved) {
                Auth::login($user, $request->has('remember'));
                return response()->json(['success' => true, 'status' => 'success', 'message' => 'You have successfully logged in.' ]);
            } else {
                return response()->json(['success' => false, 'status' => 'not approved', 'message' => 'Your account is not approved. Please contact the site administration.' ]);

            }
        }
        return response()->json(['success' => false, 'status' => 'wrong credentials', 'message' => 'These credentials do not match our records.' ]);

    }
}
